#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define MAX_N 300000

typedef struct {
    int x, y;
    int index;
    long double angle;
} Move;

Move moves[MAX_N * 2];

int compareMoves(const void *a, const void *b) {
    Move *moveA = (Move *)a;
    Move *moveB = (Move *)b;
    if (moveA->angle < moveB->angle) return -1;
    if (moveA->angle > moveB->angle) return 1;
    return 0;
}

void solve() {
    int n;
    if (scanf("%d", &n) != 1 || n < 1 || n > MAX_N) return;

    for (int i = 0; i < n; i++) {
        if (scanf("%d %d", &moves[i].x, &moves[i].y) != 2) return;
        moves[i].index = i + 1; 
        moves[i].angle = atan2((long double)moves[i].y, (long double)moves[i].x);
    }

    for (int i = 0; i < n; i++) {
        moves[n + i] = moves[i];
        moves[n + i].angle += 2 * M_PI;
    }

    qsort(moves, 2 * n, sizeof(Move), compareMoves);

    long long current_X = 0;
    long long current_Y = 0;
    long long max_dist_sq = -1;
    int best_start = -1;
    int best_end = -1;

    int start = 0;
    for (int end = 0; end < 2 * n; end++) {
        current_X += (long long)moves[end].x;
        current_Y += (long long)moves[end].y;

        while (start <= end && moves[end].angle - moves[start].angle >= M_PI + 1e-12) {
            current_X -= (long long)moves[start].x;
            current_Y -= (long long)moves[start].y;
            start++;
        }

        long long current_dist_sq = current_X * current_X + current_Y * current_Y;

        if (current_dist_sq > max_dist_sq) {
            max_dist_sq = current_dist_sq;
            best_start = start;
            best_end = end;
        }
    }

    int result_indices[MAX_N];
    int k = 0;

    for (int i = best_start; i <= best_end; i++) {
        if (moves[i].index <= n) { 
             result_indices[k++] = moves[i].index;
        }
    }

    printf("%d\n", k);
    for (int i = 0; i < k; i++) {
        printf("%d%c", result_indices[i], (i == k - 1) ? '\n' : ' ');
    }
}

int main() {
    solve();
    return 0;
}